/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon;

import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.PortAction;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.Parser;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ConnectDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton jButtonClose;
    private JButton jButtonConnect;
    private JLabel jLabel1;
    private JLabel jLabelStatus;
    private JTextField jTextConnect;

    public ConnectDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        if (Parser.connection.isConnected()) {
            this.jTextConnect.setText(Parser.connection.getHostName());
        } else {
            this.jTextConnect.setText(Sniffer.defaultIP);
        }
        this.setBounds((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2, this.getBounds().width, this.getBounds().height);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                ConnectDialog.this.updateConnectButton();
            }
        });
    }

    private void updateConnectButton() {
        if (Parser.instrument.isConnected()) {
            this.jButtonConnect.setText("Disconnect");
            this.jButtonConnect.setMnemonic('D');
            this.jLabelStatus.setText("Connected to" + Parser.address);
        } else {
            this.jButtonConnect.setText("Connect");
            this.jButtonConnect.setMnemonic('C');
            this.jLabelStatus.setText("Disconnected");
        }
    }

    private void disableAll() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jTextConnect.setEnabled(false);
        this.jButtonConnect.setEnabled(false);
        this.jButtonClose.setEnabled(false);
        this.repaint();
    }

    private void enableAll() {
        this.setCursor(Cursor.getDefaultCursor());
        this.jTextConnect.setEnabled(true);
        this.jButtonConnect.setEnabled(true);
        this.jButtonClose.setEnabled(true);
        this.repaint();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextConnect = new JTextField();
        this.jButtonConnect = new JButton();
        this.jLabelStatus = new JLabel();
        this.jButtonClose = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Connect to Analyzer...");
        this.setModal(true);
        this.setResizable(false);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor(this.jTextConnect);
        this.jLabel1.setText("Connect To:");
        this.jLabel1.setMaximumSize(new Dimension(40, 14));
        this.jLabel1.setMinimumSize(new Dimension(100, 14));
        this.jLabel1.setPreferredSize(new Dimension(100, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 33.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jTextConnect.setMinimumSize(new Dimension(200, 19));
        this.jTextConnect.setPreferredSize(new Dimension(200, 19));
        this.jTextConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.jTextConnectActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 90.0;
        gridBagConstraints.weighty = 33.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jTextConnect, gridBagConstraints);
        this.jButtonConnect.setMnemonic('C');
        this.jButtonConnect.setText("Connect");
        this.jButtonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.jButtonConnectActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 45.0;
        gridBagConstraints.weighty = 33.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jButtonConnect, gridBagConstraints);
        this.jLabelStatus.setHorizontalAlignment(0);
        this.jLabelStatus.setMaximumSize(new Dimension(40, 14));
        this.jLabelStatus.setMinimumSize(new Dimension(100, 14));
        this.jLabelStatus.setPreferredSize(new Dimension(100, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 33.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jLabelStatus, gridBagConstraints);
        this.jButtonClose.setMnemonic('C');
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.jButtonCloseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 45.0;
        gridBagConstraints.weighty = 33.3;
        this.getContentPane().add((Component)this.jButtonClose, gridBagConstraints);
        this.pack();
    }

    private void jTextConnectActionPerformed(ActionEvent actionEvent) {
        this.doConnect();
    }

    private void jButtonCloseActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void jButtonConnectActionPerformed(ActionEvent actionEvent) {
        this.doConnect();
    }

    private void doConnect() {
        this.disableAll();
        if (Parser.connection.isConnected()) {
            try {
                Parser.connection.disconnect();
            }
            catch (Exception exception) {
                Parser.connection = new SocketConnection(this.jTextConnect.getText());
            }
        } else {
            String string;
            int n;
            MainAppFrame.numDDCPorts = 0;
            MainAppFrame.numCECPorts = 0;
            this.jLabelStatus.setText("Attempting to connect to " + this.jTextConnect.getText() + "...");
            try {
                Parser.connection = new SocketConnection(this.jTextConnect.getText());
                Parser.instrument = new RemoteInstrument(Parser.connection, Parser.console);
                Parser.instrument.connect();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Unable to establish a connection with the address you specified.");
                this.enableAll();
                Sniffer.window.updateConnectionInformation();
                this.updateConnectButton();
                return;
            }
            Parser.address = this.jTextConnect.getText();
            this.jLabelStatus.setText("Connected.  Gathering information...");
            String string2 = "DDCX:NDDC?";
            InstrumentResponse instrumentResponse = Parser.instrument.sendCmd(string2);
            if (!instrumentResponse.isError() && (MainAppFrame.numDDCPorts = Integer.decode(instrumentResponse.getResponse()).intValue()) > 0) {
                MainAppFrame.analyzerDDCPorts = new Vector();
                MainAppFrame.analyzerDDCPorts.add(new PortAction("None", 0, 0, false));
                for (n = 1; n < MainAppFrame.numDDCPorts + 1; ++n) {
                    string2 = "DDC" + String.format("%1d", n) + ":PNAM?";
                    instrumentResponse = Parser.instrument.sendCmd(string2);
                    if (instrumentResponse.isError()) continue;
                    string = instrumentResponse.getResponse();
                    string2 = "DDC" + String.format("%1d", n) + ":DCMX?";
                    instrumentResponse = Parser.instrument.sendCmd(string2);
                    if (!instrumentResponse.getResponse().equals("1")) continue;
                    MainAppFrame.analyzerDDCPorts.add(new PortAction(string, n, 0, n == 1));
                }
            }
            if (!(instrumentResponse = Parser.instrument.sendCmd(string2 = "CECX:NCEC?")).isError()) {
                MainAppFrame.numCECPorts = Integer.decode(instrumentResponse.getResponse());
                if (MainAppFrame.numCECPorts > 0) {
                    MainAppFrame.analyzerCECPorts = new Vector();
                    MainAppFrame.analyzerCECPorts.add(new PortAction("None", 0, 1, false));
                    for (n = 1; n < MainAppFrame.numCECPorts + 1; ++n) {
                        string2 = "CEC" + String.format("%1d", n) + ":PNAM?";
                        instrumentResponse = Parser.instrument.sendCmd(string2);
                        if (instrumentResponse.isError()) continue;
                        string = instrumentResponse.getResponse();
                        string2 = "CEC" + String.format("%1d", n) + ":BUSM?";
                        instrumentResponse = Parser.instrument.sendCmd(string2);
                        if (!instrumentResponse.getResponse().equals("1")) continue;
                        MainAppFrame.analyzerCECPorts.add(new PortAction(string, n, 1, n == 1));
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The analyzer reports no CEC subsystems to monitor.");
                }
            } else {
                JOptionPane.showMessageDialog(this, "There was an error when asking how many CEC subsystems were present.\n\nThe command was:\n" + string2 + "\n\nAnd the response was:\n" + instrumentResponse.toString());
            }
            if (MainAppFrame.numDDCPorts + MainAppFrame.numCECPorts == 0) {
                JOptionPane.showMessageDialog(this, "Connection to the analyzer was successful; however, this analyzer reports no I2C or CEC subsystems which can be monitored.");
            }
            if ((instrumentResponse = Parser.instrument.sendCmd(string2 = "QD:DCPX:LOGG?")).isError()) {
                MainAppFrame.enable5VoltTPAAction.setEnabled(false);
            } else {
                MainAppFrame.enable5VoltTPAAction.setEnabled(true);
                if (instrumentResponse.getResponse().startsWith("1")) {
                    MainAppFrame.enable5VoltTPAAction.setValue(true);
                } else {
                    MainAppFrame.enable5VoltTPAAction.setValue(false);
                }
            }
        }
        this.enableAll();
        Sniffer.window.updateConnectionInformation();
        this.updateConnectButton();
        if (Parser.instrument.isConnected()) {
            this.setVisible(false);
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ConnectDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

